//==============================================================================
// Project:		Wealth Transfers and their economic effects
// File name:	Inheritances due to within-household deaths
// Objective: 	Generate an indicator for inheritances due to within-household deaths
//
//==============================================================================

clear all

cd "XXXX"

use combined_filtered_restricted.dta, replace
xtset xwaveid wave

gen dies_2_years = 0
replace dies_2_years = 1 if yodeath >= wave + 2000 & yodeath <= wave + 2002 //flag for person in question dying later this year or in the following two years

gen dies_1_year = 0
replace dies_1_year = 1 if yodeath >= wave + 2000 & yodeath <= wave + 2001 //flag for person in question dying later this year or in the following year

egen HH_dies_2_years = max(dies_2_years), by(hhrhid wave)
egen HH_dies_1_year = max(dies_1_year), by(hhrhid wave)
gen L2_HH_dies_2_years = L2.HH_dies_2_years
gen L_HH_dies_1_year = L.HH_dies_1_year
egen HH_death = rowmax(L2_HH_dies_2_years L_HH_dies_1_year) //flag for HH member who lived with person in question in previous wave or two waves prior having died by the end of the current year

*Attach to inheritances

drop if hgint == 0

gen bequest = oifinha
replace bequest = 0 if bequest == -1
replace bequest = . if bequest < -1

gen bequest_from_HH_death = 0
replace bequest_from_HH_death = 1 if HH_death == 1 & bequest > 0 & bequest != .

codebook bequest_from_HH_death //142 inheritances identified

keep xwaveid wave bequest_from_HH_death

save bequest_from_HH_death.dta, replace
